<?php
namespace VM\FinancialStatementsBundle\Services\Restrictions\DataStructure;


use Import\ApiBundle\Entity\AllegroCategoryItem;

class ItemDS
{
    public $id = 0;

    public $name = '';

    public $price = 0;

    public $periodOfNotice = 0;

    public $bail = 0;

    public $surface = 0;

    public $typeSymbol = '';

    //liczba posiadanych lub wymaganych sztuk
    public $quantity = 1;

    public $used = 0;

    public function __construct(AllegroCategoryItem $Item,$quantity = 1)
    {
        $this->id = $Item->getId();
        $this->name = $Item->getName();
        $this->price = $Item->getBuyNowPrice();
        $this->periodOfNotice = $Item->getPeriodOfNotice();
        $this->bail = $Item->getBail();
        $this->surface = $Item->getSurface();
        $this->typeSymbol = $Item->getType()->getSymbol();
        $this->quantity = $quantity;
    }
}